/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.hardware;

import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.model.AsymPulseGeneratorParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.HighResolutionSeconds;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.MemoryUsageTable;
import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.ParameterItemTableLogo4;
import DE.siemens.ad.logo.model.SymPulseGeneratorParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.block.AmplifierBlock;
import DE.siemens.ad.logo.model.block.AnalogComparatorBlock;
import DE.siemens.ad.logo.model.block.AnalogDeltaTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogWatchdogBlock;
import DE.siemens.ad.logo.model.block.AndBlock;
import DE.siemens.ad.logo.model.block.AsymPulseGeneratorBlock;
import DE.siemens.ad.logo.model.block.ClockBlock;
import DE.siemens.ad.logo.model.block.ComfortSwitchBlock;
import DE.siemens.ad.logo.model.block.CounterBlock;
import DE.siemens.ad.logo.model.block.HoursCounterBlock;
import DE.siemens.ad.logo.model.block.LatchingRelayBlock;
import DE.siemens.ad.logo.model.block.MessageBlock;
import DE.siemens.ad.logo.model.block.NandBlock;
import DE.siemens.ad.logo.model.block.NorBlock;
import DE.siemens.ad.logo.model.block.NotBlock;
import DE.siemens.ad.logo.model.block.OffDelayBlock;
import DE.siemens.ad.logo.model.block.OnDelayBlock;
import DE.siemens.ad.logo.model.block.OnOffDelayBlock;
import DE.siemens.ad.logo.model.block.OrBlock;
import DE.siemens.ad.logo.model.block.PecAndBlock;
import DE.siemens.ad.logo.model.block.PecNandBlock;
import DE.siemens.ad.logo.model.block.PulseRelayBlock;
import DE.siemens.ad.logo.model.block.RandomBlock;
import DE.siemens.ad.logo.model.block.RetentiveOnDelayBlock;
import DE.siemens.ad.logo.model.block.ShiftRegisterBlock;
import DE.siemens.ad.logo.model.block.SoftkeyBlock;
import DE.siemens.ad.logo.model.block.StairsSwitchBlock;
import DE.siemens.ad.logo.model.block.SymPulseGeneratorBlock;
import DE.siemens.ad.logo.model.block.TriggerBlock;
import DE.siemens.ad.logo.model.block.WipingRelayBlock;
import DE.siemens.ad.logo.model.block.WipingRelayPECBlock;
import DE.siemens.ad.logo.model.block.XorBlock;
import DE.siemens.ad.logo.model.block.YearClockBlock;
import DE.siemens.ad.logo.model.hardware.Modular0;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromHardware;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo4;
import DE.siemens.ad.logo.model.visitor.build.CompilerToHardware;
import DE.siemens.ad.logo.model.visitor.build.CompilerToLogo4;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo4;
import DE.siemens.ad.logo.util.AnchorMemory16;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.Memory16;
import DE.siemens.ad.logo.util.MemoryEnumeration;
import DE.siemens.ad.logo.util.MessageMemory8;
import DE.siemens.ad.logo.util.ProgramMemory16;
import DE.siemens.ad.logo.util.TimeValueProperties;
import java.util.Dictionary;
import java.util.Hashtable;

public class Logo4
extends Modular0 {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    public static int ADR_DISPLAY_TRANSFER_ON = 12295;

    public int getOrder() {
        return 1100;
    }

    protected static Dictionary getSystemInfo() {
        Hashtable<String, Object> dict = new Hashtable<String, Object>(20);
        dict.put("knownBlocks", Logo4.getBlockNamesArray());
        TimeUnit[] availableTimeUnits = new TimeUnit[]{new Hours(), new Minutes(), new HighResolutionSeconds()};
        dict.put("availableTimeUnits", availableTimeUnits);
        int[] iArr = new int[]{130, Integer.MAX_VALUE, 60, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 24, 16, 0, 0, 24, 8, 10, 2, 2000, 64, 6, 4, 1, 8, 16};
        dict.put("maxValues", iArr);
        dict.put("blockMemoryTable", new BlockMemoryUsage());
        dict.put("blockActualParameterMemory", new BlockActualMemoryUsage());
        dict.put("blockREMMemoryTable", new BlockREMMemoryUsage());
        dict.put("parameterItemTable", new ParameterItemTableLogo4());
        Logo4.addPropertyItems(dict);
        Logo4.addSupportItems(dict);
        return dict;
    }

    protected static String[][] getBlockNamesArray() {
        String[][] sArr = new String[][]{{"Constant", "Input", "KeyInput", "Output", "Marker", "AnalogMarker", "High", "Low", "AnalogInput", "AnalogOutput", "ShiftRegisterInput", "VirtualOutput"}, {"Base", "And", "Or", "Not", "Xor", "Nand", "Nor", "PecAnd", "PecNand"}, {"Special", "OnDelay", "OffDelay", "PulseRelay", "Clock", "LatchingRelay", "RetentiveOnDelay", "Counter", "HoursCounter", "WipingRelay", "Trigger", "AsymPulseGenerator", "YearClock", "OnOffDelay", "Random", "StairsSwitch", "ComfortSwitch", "WipingRelayPEC", "Message", "AnalogTrigger", "AnalogComparator", "Amplifier", "AnalogWatchdog", "AnalogDeltaTrigger", "ShiftRegister", "Softkey"}};
        return sArr;
    }

    protected static void addPropertyItems(Hashtable dict) {
        dict.put("displayWidth", new Integer(12));
        dict.put("maxWatchedBlocksCount", new Integer(30));
        dict.put("maxWatchedBytesCount", new Integer(140));
        dict.put("msgPrioCount", new Integer(31));
    }

    protected static void addSupportItems(Hashtable dict) {
        dict.put("longCounter", Boolean.TRUE);
        dict.put("blockmode", Boolean.TRUE);
        dict.put("asymPulseWithDifferentTimeUnits", Boolean.TRUE);
        dict.put("anyDayClock", Boolean.TRUE);
        dict.put("readFunctionParameter", Boolean.TRUE);
        dict.put("mixedMessageTextAndParameter", Boolean.TRUE);
        dict.put("messageBlockWithReceipt", Boolean.TRUE);
        dict.put("4BaseBlockInputs", Boolean.TRUE);
        dict.put("negatableInputs", Boolean.TRUE);
        dict.put("pulseRelayWithSetInput", Boolean.TRUE);
        dict.put("clockOneProtection", Boolean.TRUE);
        dict.put("extHourscounter", Boolean.TRUE);
        dict.put("REMTimer", Boolean.TRUE);
        dict.put("twoLimes", Boolean.TRUE);
        dict.put("onlineTest", Boolean.TRUE);
        dict.put("referenceFunction", Boolean.TRUE);
        dict.put("stairsSwitchWarning", Boolean.TRUE);
        dict.put("comfortSwitchResetWarning", Boolean.TRUE);
        dict.put("yearClockEveryDay", Boolean.TRUE);
        dict.put("softkeyProtection", Boolean.TRUE);
        dict.put("messageProtection", Boolean.TRUE);
        dict.put("wipingPecR", Boolean.TRUE);
        dict.put("userBlockName", Boolean.TRUE);
        dict.put("AnalogValueDecimalPlaces", Boolean.TRUE);
        dict.put("analogComparatorOnOff", Boolean.TRUE);
        dict.put("swtExt", Boolean.TRUE);
        dict.put("0BA4Calculation", Boolean.TRUE);
        dict.put("readHourCounterWithoutCopy", Boolean.TRUE);
        dict.put("swVersion", Boolean.TRUE);
        dict.put("transmissionPossible", Boolean.TRUE);
        dict.put("combiModule", Boolean.TRUE);
        dict.put("prgName", Boolean.TRUE);
        dict.put("password", Boolean.TRUE);
        dict.put("0BA4AnalogCalculation", Boolean.TRUE);
    }

    protected String getIconName() {
        return this.getName() + "Icon.gif";
    }

    public int getOpcodeCO(String name, int blockNr) throws IllegalArgumentException {
        return this.getRealCOOpcode(name, --blockNr) | 0x1000000;
    }

    protected int getRealCOOpcode(String name, int blockNr) {
        if (name.equals("Input")) {
            return 0 + blockNr;
        }
        if (name.equals("Output")) {
            return 48 + blockNr;
        }
        if (name.equals("Marker")) {
            return 80 + blockNr;
        }
        if (name.equals("AnalogInput")) {
            return 128 + blockNr;
        }
        if (name.equals("AnalogOutput")) {
            return 144 + blockNr;
        }
        if (name.equals("AnalogMarker")) {
            return 146 + blockNr;
        }
        if (name.equals("KeyInput")) {
            return 160 + blockNr;
        }
        if (name.equals("ShiftRegisterInput")) {
            return 176 + blockNr;
        }
        if (name.equals("VirtualOutput")) {
            return 192 + blockNr;
        }
        if (name.equals("High")) {
            return 253;
        }
        if (name.equals("Low")) {
            return 254;
        }
        throw new IllegalArgumentException();
    }

    public int calculateBlockNumber(int opcode) throws IllegalArgumentException {
        if (opcode < 24) {
            return opcode + 1;
        }
        if (opcode < 48) {
            throw new IllegalArgumentException("Illegal opcode: " + opcode);
        }
        if (opcode < 64) {
            return opcode - 48 + 1;
        }
        if (opcode < 50) {
            throw new IllegalArgumentException("Illegal opcode: " + opcode);
        }
        if (opcode < 104) {
            return opcode - 80 + 1;
        }
        if (opcode < 128) {
            throw new IllegalArgumentException("Illegal opcode: " + opcode);
        }
        if (opcode < 136) {
            return opcode - 128 + 1;
        }
        if (opcode < 144) {
            throw new IllegalArgumentException("Illegal opcode: " + opcode);
        }
        if (opcode < 146) {
            return opcode - 144 + 1;
        }
        if (opcode < 152) {
            return opcode - 146 + 1;
        }
        if (opcode < 160) {
            throw new IllegalArgumentException("Illegal opcode: " + opcode);
        }
        if (opcode < 164) {
            return opcode - 160 + 1;
        }
        if (opcode < 176) {
            throw new IllegalArgumentException("Illegal opcode: " + opcode);
        }
        if (opcode < 184) {
            return opcode - 176 + 1;
        }
        if (opcode < 192) {
            throw new IllegalArgumentException("Illegal opcode: " + opcode);
        }
        if (opcode < 208) {
            return opcode - 192 + 1;
        }
        if (opcode < 252) {
            throw new IllegalArgumentException("Illegal opcode: " + opcode);
        }
        if (opcode < 255) {
            return 0;
        }
        throw new IllegalArgumentException("Illegal opcode: " + opcode);
    }

    protected int getOpcodeGF(String name) throws IllegalArgumentException {
        if (name.equals("And")) {
            return 1;
        }
        if (name.equals("Or")) {
            return 2;
        }
        if (name.equals("Not")) {
            return 3;
        }
        if (name.equals("Nand")) {
            return 4;
        }
        if (name.equals("Nor")) {
            return 5;
        }
        if (name.equals("Xor")) {
            return 6;
        }
        if (name.equals("PecAnd")) {
            return 7;
        }
        if (name.equals("PecNand")) {
            return 8;
        }
        throw new IllegalArgumentException();
    }

    protected int getOpcodeSF(String name) throws IllegalArgumentException {
        if (name.equals("OnDelay")) {
            return 33;
        }
        if (name.equals("OffDelay")) {
            return 34;
        }
        if (name.equals("PulseRelay")) {
            return 35;
        }
        if (name.equals("Clock")) {
            return 36;
        }
        if (name.equals("LatchingRelay")) {
            return 37;
        }
        if (name.equals("RetentiveOnDelay")) {
            return 39;
        }
        if (name.equals("HoursCounter")) {
            return 41;
        }
        if (name.equals("WipingRelay")) {
            return 42;
        }
        if (name.equals("WipingRelay")) {
            return 42;
        }
        if (name.equals("Counter")) {
            return 43;
        }
        if (name.equals("Trigger")) {
            return 44;
        }
        if (name.equals("AsymPulseGenerator")) {
            return 45;
        }
        if (name.equals("YearClock")) {
            return 46;
        }
        if (name.equals("OnOffDelay")) {
            return 47;
        }
        if (name.equals("Random")) {
            return 48;
        }
        if (name.equals("StairsSwitch")) {
            return 49;
        }
        if (name.equals("ComfortSwitch")) {
            return 50;
        }
        if (name.equals("WipingRelayPEC")) {
            return 51;
        }
        if (name.equals("Message")) {
            return 52;
        }
        if (name.equals("AnalogTrigger")) {
            return 53;
        }
        if (name.equals("AnalogComparator")) {
            return 54;
        }
        if (name.equals("Softkey")) {
            return 55;
        }
        if (name.equals("ShiftRegister")) {
            return 56;
        }
        if (name.equals("AnalogWatchdog")) {
            return 57;
        }
        if (name.equals("AnalogDeltaTrigger")) {
            return 58;
        }
        if (name.equals("Amplifier")) {
            return 66;
        }
        throw new IllegalArgumentException("getOpcodeSF: Illegal Opcode " + name);
    }

    public Block getSubstitutionBlock(Block orgBlock) throws IllegalArgumentException {
        if (orgBlock.getClass() == SymPulseGeneratorBlock.class) {
            AsymPulseGeneratorBlock newBlock = new AsymPulseGeneratorBlock();
            newBlock.setNumber(orgBlock.getNumber());
            SymPulseGeneratorParameter param = (SymPulseGeneratorParameter)orgBlock.getParameter();
            TimeValueProperties oldTime = param.getParamTime();
            AsymPulseGeneratorParameter newParam = (AsymPulseGeneratorParameter)newBlock.getParameter();
            newParam.setHTimerParamTime(oldTime);
            newParam.setLTimerParamTime(oldTime);
            newParam.setProtection(param.getProtection());
            return newBlock;
        }
        return super.getSubstitutionBlock(orgBlock);
    }

    public int getID() {
        return 64;
    }

    public int getFirmwareID() {
        return 96;
    }

    public int getNumberOfTransferBytes() {
        return 3728;
    }

    public int getAdress(int name) {
        if (name == ADR_CHECKSUM) {
            return 1374;
        }
        if (name == ADR_FIRMWARE_ID) {
            return 1372;
        }
        if (name == ADR_PROGRAM_NAME) {
            return 1392;
        }
        if (name == ADR_PASSWORD) {
            return 1382;
        }
        if (name == ADR_DISPLAY_TRANSFER_ON) {
            return 18240;
        }
        if (name == ADR_SW_VERSION) {
            return 7936;
        }
        return super.getAdress(name);
    }

    protected boolean downloadChecksum(DataTransfer dt, int checksum) throws TransmissionFailedException {
        dt.writeByte(this.getAdress(ADR_CHECKSUM), checksum & 0xFF);
        dt.writeNextByte((checksum & 0xFF00) >> 8);
        return true;
    }

    protected int uploadChecksum(DataTransfer dt) throws TransmissionFailedException {
        int retWert = dt.readByte(this.getAdress(ADR_CHECKSUM)) & 0xFF;
        return retWert += (dt.readNextByte() & 0xFF) << 8;
    }

    protected int getChecksum() {
        int checksum = 0;
        MemoryEnumeration offsetTable = this.getMemory("ProgOffsetTabelle").elements();
        for (int i = 0; i < 10; ++i) {
            int element = offsetTable.nextWord();
            checksum = (short)(checksum + element);
        }
        checksum = (short)(checksum + this.getChecksumAnchorMemories());
        checksum = (short)(checksum + this.getChecksumProgramMemory(offsetTable));
        int result = checksum & 0xFFFF;
        return result;
    }

    protected int getChecksumAnchorMemories() {
        int checksum = 0;
        Memory[] array = this.getMemories();
        for (int i = 0; i < array.length; ++i) {
            Memory mem = array[i];
            if (!(mem instanceof AnchorMemory16)) continue;
            int blockSize = mem.getBlockSize();
            int memEnd = mem.size() * blockSize;
            int csLength = this.getAnchorMemoryValidLength(mem);
            for (int lineOffset = 0; lineOffset < memEnd; lineOffset += blockSize) {
                for (int k = 0; k < csLength; k += 2) {
                    checksum = (short)(checksum + mem.getWord(lineOffset + k));
                }
            }
        }
        return checksum;
    }

    protected int getAnchorMemoryValidLength(Memory mem) {
        return mem.getBlockSize() - 2;
    }

    protected int getChecksumProgramMemory(MemoryEnumeration offsetTable) {
        int checksum = 0;
        Memory mem = this.getMemory("Program");
        while (offsetTable.hasMoreElements()) {
            int element = offsetTable.nextWord();
            if (element == 65535) continue;
            checksum = (short)(checksum + element);
            int start = element - this.getProgramLineAddressOffset();
            int csLength = this.getActualDataOffset(mem.get(start));
            int end = csLength + start;
            boolean oddLength = false;
            if (csLength % 2 > 0) {
                oddLength = true;
                --end;
            }
            for (int i = start; i < end; i += 2) {
                checksum = (short)(checksum + mem.getWord(i));
            }
            if (!oddLength) continue;
            checksum = (short)(checksum + (mem.getWord(end) & 0xFF));
        }
        return checksum;
    }

    protected int getProgramLineAddressOffset() {
        return 200;
    }

    protected int getActualDataOffset(int opcode) {
        switch (opcode) {
            case 128: {
                return 20;
            }
            case 1: {
                return 12;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 12;
            }
            case 5: {
                return 12;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 12;
            }
            case 8: {
                return 12;
            }
            case 33: {
                return 6;
            }
            case 34: {
                return 8;
            }
            case 35: {
                return 9;
            }
            case 36: {
                return 17;
            }
            case 37: {
                return 6;
            }
            case 39: {
                return 8;
            }
            case 41: {
                return 15;
            }
            case 42: {
                return 6;
            }
            case 43: {
                return 16;
            }
            case 44: {
                return 10;
            }
            case 45: {
                return 10;
            }
            case 46: {
                return 8;
            }
            case 47: {
                return 8;
            }
            case 48: {
                return 8;
            }
            case 49: {
                return 10;
            }
            case 50: {
                return 14;
            }
            case 51: {
                return 12;
            }
            case 52: {
                return 8;
            }
            case 53: {
                return 13;
            }
            case 54: {
                return 15;
            }
            case 55: {
                return 6;
            }
            case 56: {
                return 9;
            }
            case 57: {
                return 13;
            }
            case 58: {
                return 13;
            }
            case 66: {
                return 10;
            }
        }
        throw new IllegalArgumentException("getActualDataOffset- Unbekannter Opcode: " + opcode);
    }

    public CompilerFromHardware getCompilerFromHardware() {
        return new CompilerFromLogo4();
    }

    public CompilerToHardware getCompilerToHardware() {
        return new CompilerToLogo4();
    }

    public LinkerToLogo getLinkerToHardware() {
        return new LinkerToLogo4(this);
    }

    public Memory[] getMemories() {
        if (this.fMemories == null) {
            this.fMemories = new Memory[10];
            int nrOfBlocknames = this.getMaxResource(15);
            this.fMemories[0] = new Memory("BlocknamenTabelle", 1472, nrOfBlocknames, 1);
            this.fMemories[1] = new Memory("Blocknamen", 1536, nrOfBlocknames, 8);
            this.fMemories[2] = new MessageMemory8("Meldetext", 2048, this.getMaxResource(12) * 4, 16);
            ((MessageMemory8)this.fMemories[2]).setAllByteAtOnce(true);
            this.fMemories[3] = new Memory16("ProgOffsetTabelle", 3072, this.getMaxResource(0) + 10, 2);
            this.fMemories[4] = new AnchorMemory16("Anker Q1...Qi", 3616, 2, 20, 48);
            this.fMemories[5] = new AnchorMemory16("Merker", 3656, 3, 20, 80);
            this.fMemories[6] = new AnchorMemory16("Analoganker", 3716, 1, 20, 144);
            this.fMemories[7] = new AnchorMemory16("Virtuelle Anker", 3736, 2, 20, 192);
            this.fMemories[8] = new AnchorMemory16("Reserviert", 3776, 2, 20, 0);
            this.fMemories[9] = new ProgramMemory16("Program", 3816, this.getMaxResource(14), 1);
        }
        return this.fMemories;
    }

    public int uploadFirmwareID(DataTransfer dt) throws TransmissionFailedException {
        int retWert = dt.readNextByte();
        return retWert += (dt.readByte(this.getAdress(ADR_FIRMWARE_ID)) & 0xFF) << 8;
    }

    public void downloadTransferScreenOn(DataTransfer dt) throws TransmissionFailedException {
        dt.writeByte(this.getAdress(ADR_DISPLAY_TRANSFER_ON), 0);
    }

    static {
        cSystemInfoDict.put("Logo4", Logo4.getSystemInfo());
    }

    private static class BlockREMMemoryUsage
    extends MemoryUsageTable {
        private BlockREMMemoryUsage() {
        }

        protected void initializeTable() {
            this.put(OnDelayBlock.class, 3);
            this.put(OffDelayBlock.class, 3);
            this.put(PulseRelayBlock.class, 1);
            this.put(LatchingRelayBlock.class, 1);
            this.put(RetentiveOnDelayBlock.class, 3);
            this.put(HoursCounterBlock.class, 9);
            this.put(WipingRelayBlock.class, 3);
            this.put(CounterBlock.class, 5);
            this.put(AsymPulseGeneratorBlock.class, 3);
            this.put(OnOffDelayBlock.class, 3);
            this.put(StairsSwitchBlock.class, 3);
            this.put(ComfortSwitchBlock.class, 3);
            this.put(WipingRelayPECBlock.class, 4);
            this.put(SoftkeyBlock.class, 2);
            this.put(ShiftRegisterBlock.class, 1);
        }
    }

    private static class BlockActualMemoryUsage
    extends MemoryUsageTable {
        private BlockActualMemoryUsage() {
        }

        protected void initializeTable() {
            this.put(OnDelayBlock.class, 4);
            this.put(OffDelayBlock.class, 6);
            this.put(PulseRelayBlock.class, 5);
            this.put(ClockBlock.class, 5);
            this.put(LatchingRelayBlock.class, 4);
            this.put(RetentiveOnDelayBlock.class, 6);
            this.put(HoursCounterBlock.class, 11);
            this.put(WipingRelayBlock.class, 4);
            this.put(CounterBlock.class, 10);
            this.put(TriggerBlock.class, 8);
            this.put(AsymPulseGeneratorBlock.class, 4);
            this.put(YearClockBlock.class, 2);
            this.put(OnOffDelayBlock.class, 6);
            this.put(RandomBlock.class, 6);
            this.put(StairsSwitchBlock.class, 4);
            this.put(ComfortSwitchBlock.class, 4);
            this.put(WipingRelayPECBlock.class, 6);
            this.put(MessageBlock.class, 2);
            this.put(AnalogTriggerBlock.class, 5);
            this.put(AnalogComparatorBlock.class, 11);
            this.put(SoftkeyBlock.class, 4);
            this.put(ShiftRegisterBlock.class, 2);
            this.put(AmplifierBlock.class, 4);
            this.put(AnalogWatchdogBlock.class, 9);
            this.put(AnalogDeltaTriggerBlock.class, 5);
        }
    }

    private static class BlockMemoryUsage
    extends MemoryUsageTable {
        private BlockMemoryUsage() {
        }

        protected void initializeTable() {
            this.put(AndBlock.class, 12);
            this.put(OrBlock.class, 12);
            this.put(NotBlock.class, 4);
            this.put(NandBlock.class, 12);
            this.put(NorBlock.class, 12);
            this.put(XorBlock.class, 8);
            this.put(PecAndBlock.class, 12);
            this.put(PecNandBlock.class, 12);
            this.put(OnDelayBlock.class, 8);
            this.put(OffDelayBlock.class, 12);
            this.put(PulseRelayBlock.class, 12);
            this.put(ClockBlock.class, 20);
            this.put(LatchingRelayBlock.class, 8);
            this.put(RetentiveOnDelayBlock.class, 12);
            this.put(HoursCounterBlock.class, 24);
            this.put(WipingRelayBlock.class, 8);
            this.put(CounterBlock.class, 24);
            this.put(TriggerBlock.class, 16);
            this.put(AsymPulseGeneratorBlock.class, 12);
            this.put(YearClockBlock.class, 8);
            this.put(OnOffDelayBlock.class, 12);
            this.put(RandomBlock.class, 12);
            this.put(StairsSwitchBlock.class, 12);
            this.put(ComfortSwitchBlock.class, 16);
            this.put(WipingRelayPECBlock.class, 16);
            this.put(MessageBlock.class, 8);
            this.put(AnalogTriggerBlock.class, 16);
            this.put(AnalogComparatorBlock.class, 24);
            this.put(SoftkeyBlock.class, 8);
            this.put(ShiftRegisterBlock.class, 12);
            this.put(AmplifierBlock.class, 12);
            this.put(AnalogWatchdogBlock.class, 20);
            this.put(AnalogDeltaTriggerBlock.class, 16);
        }
    }
}

